% FICHERO PARA DEMOSTRACION DE METODOS DE DIFERENCIAS FINITAS.
% PROBLEMA DE ONDAS UNIDIMENSIONALES EN UNA CUERDA.
%% 
% ejemplo de la cuerda con FDTD
%
clear;
L  = 1.0;
T  = 10.0 ;    % tension 
mu = 1.0/L ;   % densidad de masa
c  = sqrt(T/mu) ;    % velocidad de la onda

nx = 100;
tmax = 1.0 ;  % maximo tiempo de simulacion
xa = 0.0d0;    % coordenadas de los puntos extremos
xb = L ;     
ua = 0.0;
ub = 0.0;
dx = (xb-xa)/(nx-1);
dt = dx/c*0.9;  %para inestabilidad, multiplicar por 1.0008;

u0  = zeros(nx,1);
du0 = zeros(nx,1);
x   = linspace( xa, xb, nx);
for ii = 2:nx-1
   u0(ii)  = exp( -100*(x(ii)-0.65)^2 );
end

[uu]=fdtd_cuerda( xa, xb, u0, du0, ua, ub, c, tmax, dt, nx);

[nx, nt] = size(uu);
umax = max(max(uu));
umin = min(min(uu));
t = 0.0;
for ii = 1:nt
    clf;
    plot(x,uu(:,ii),'o-');
    axis([xa xb umin  umax]);
    legend( sprintf('tiempo = %e',t),'Location','North');
    pause(0.01);
    t = t + dt;
 end